/** @file   LightballAlien.h
 * @brief   Declaration of LightballAlien class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_LIGHTBALLALIEN_H
#define H_WWW_LIGHTBALLALIEN_H

#include "alien.h"

namespace WeWantWar {

/** @class  LightballAlien
 * @brief   Alien that shoots fireballs.
 * @author  Tomi Lamminsaari
 *
 */
class LightballAlien : public Alien
{
public:

  ///
  /// Constants, datatypes and static methods
  /// =======================================

  /** Index of the gun nose controlpoint. */
  static const int GUNNOSE_CONTROLPOINT = 0;

  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Default constructor.
   */
  LightballAlien();

  /** Destructor
   */
  ~LightballAlien();

private:
  
  /** Copy constructor
   * @param   aAnother          Reference to another LightballAlien
   */
  LightballAlien( const LightballAlien& aAnother );

  /** An assignment operator
   * @param   aAnother          Reference to another LightballAlien
   * @return  Reference to this object.
   */
  LightballAlien& operator= ( const LightballAlien& aAnother );

public:

  ///
  /// Inherited methods
  /// =================

  /** Updates this object.
   */
  virtual void update();
  
  /** Makes sound.
   * @param   aSoundId          Id of the sound we must make.
   */
  virtual void makeSound( GameObject::SoundID aSoundId ) const;
  
  /** Handles the bullet hits
   * @param   aBullet           Pointer to bullet that hit us.
   * @return  <code>true</code> if we accept the bullet hit.
   */
  virtual bool hitByBullet( Bullet* aBullet );
  
  /** Kills this object.
   */
  virtual void kill();
  
  /** Returns the type of this object.
   * @return  ObjectID::TYPE_LIGHTBALLALIEN
   */
  virtual ObjectID::Type objectType() const;

  ///
  /// New public methods
  /// ==================


  ///
  /// Getter methods
  /// ==============


protected:
  ///
  /// Protected interface
  /// ===================

  /** Sets the requested animation.
   * @param   aAnimId           Id of the animation we should setup
   */
  virtual void setCorrectAnimation( int aAnimId );
  
  /** Shoots
   */
  virtual void attack();


protected:
  ///
  /// Data members
  /// ============

  /** Walking velocity vector. */
  eng2d::Vec2D iWalkVec;
  
  /** Reloading delay. */
  int iReloadingDelay;
};

};  // end of namespace

#endif
